<?php

require_once('tcpdf_include.php');

if( $_GET['type'] == "" )
{
	
	require "../config/db.php";
	require "../config/common.php";
	require "../config/functions.php";
	$conn = db_connect();
}

if ( isset($_GET['id']) )
{
	$qinvoice = mysqli_query ( $conn, "SELECT * FROM tblinvoices WHERE md5_id='".$_GET['id']."' LIMIT 1" );
	$qinvoicerow = mysqli_fetch_assoc ( $qinvoice );
}
else
{
	$qinvoice = mysqli_query ( $conn, "SELECT * FROM tblinvoices WHERE id='0' LIMIT 1" );
	$qinvoicerow = mysqli_fetch_assoc ( $qinvoice );
}

$qclient = mysqli_query ( $conn,"SELECT * FROM tblclients WHERE id='".$qinvoicerow['client_id']."' LIMIT 1" );
$qclientrow = mysqli_fetch_assoc ( $qclient );

$qsettings = mysqli_query ( $conn, "SELECT * FROM tblsettings LIMIT 1" );
$qsettingsrow = mysqli_fetch_assoc ( $qsettings );

$filename = 'Invoice-'.$qinvoicerow['id'].'.pdf';

// create new PDF document
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor($qsettingsrow['title']);
$pdf->SetTitle($qsettingsrow['title'].' Invoice');
$pdf->SetSubject($qsettingsrow['title'].' Invoice');
$pdf->SetKeywords($qsettingsrow['title'].' Invoice');

// set default header data
//$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 001', PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING, array(0,64,255), array(0,64,128));
$pdf->setFooterData(array(0,64,0), array(0,64,128));

// remove default header/footer
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

$PDF_HEADER_LOGO = "";//any image file. check correct path.
$PDF_HEADER_LOGO_WIDTH = "";
$PDF_HEADER_TITLE = "";
$PDF_HEADER_STRING = "";
$pdf->SetHeaderData($PDF_HEADER_LOGO, $PDF_HEADER_LOGO_WIDTH, $PDF_HEADER_TITLE, $PDF_HEADER_STRING);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP-20, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM-20);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
	require_once(dirname(__FILE__).'/lang/eng.php');
	$pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set default font subsetting mode
$pdf->setFontSubsetting(true);

// Set font
// dejavusans is a UTF-8 Unicode font, if you only need to
// print standard ASCII chars, you can use core fonts like
// helvetica or times to reduce file size.
$pdf->SetFont('helvetica', '', 10, '', true);

// Add a page
// This method has several options, check the source code documentation for more information.
$pdf->AddPage();

// set text shadow effect
$pdf->setTextShadow(array('enabled'=>false, 'depth_w'=>0.2, 'depth_h'=>0.2, 'color'=>array(196,196,196), 'opacity'=>1, 'blend_mode'=>'Normal'));

// Set some content to print
$html = '';
$html .= '<table width="100%" border="0" cellspacing="2" cellpadding="2">';
$html .= '<tr><td style="text-align:left;"><img src="../images/logo.png" width="150"></td><td style="text-align:right;">'.nl2br($qsettingsrow['address']).'</td></tr>';
$html .= '<tr><td style="text-align:center;" colspan="2"><hr></td></tr>';
$html .= '</table>';

$html .= '
<table width="100%" border="0" cellspacing="2" cellpadding="2">
  <tr>
    <td><table width="100%" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td width="50%" valign="top"><strong>Invoice To:</strong><br>';
          $html .= $qclientrow['name'].' '. $qclientrow['surname'].'<br />';
		  if( $qclientrow ['mobile'] != "" )$html .= 'Mobile: '.$qclientrow ['mobile'].'<br />';
		  if( $qclientrow ['phone'] != "" )$html .= 'Phone: '.$qclientrow ['phone'].'<br />';
		  $html .= 'Email: '.$qclientrow ['email'].'<br />';
          $html .= '</td>';
		  if( $qsettingsrow['pay_to_text'] != "" )
		  {
          $html .= '<td valign="top"><strong>Pay To:</strong><br>';
		  $html .= nl2br($qsettingsrow['pay_to_text']).'<br />';
		  $html .= '</td>';
		  }
      $html .= '</tr>
	  <tr>
        <td width="50%" valign="top"><strong>Reference:</strong><br>Invoice '.$qinvoicerow['id'].'</td>
        <td valign="top"><strong>Invoice Date:</strong><br />'.func_date ( $qinvoicerow['invoice_date'] ).'</td>
      </tr>
    </table></td>
  </tr>
  <tr>
    <td>&nbsp;</td>
  </tr>
  <tr>
    <td>
		<table width="100%" border="0" cellspacing="0" cellpadding="0">
		  <tr>
			<td width="50%" valign="top"><h2>Invoice #'.$qinvoicerow['id'].'</h2></td>
			<td width="50%">';
			if( $qinvoicerow['status'] == "Paid" )$html .= '<h2 style="color:#00A600;">'.$qinvoicerow['status'].'</h2>';
			if( $qinvoicerow['status'] == "Unpaid" )$html .= '<h2 style="color:#EC2F2F;">'.$qinvoicerow['status'].'</h2>';
			if( $qinvoicerow['status'] == "Cancelled" )$html .= '<h2 style="color:#868E96;">'.$qinvoicerow['status'].'</h2>';
			$html .= '</td>
		  </tr>
		</table>
	</td>
  </tr>
  <tr>
    <td><table width="100%" border="0" cellspacing="0" cellpadding="10">
      <tr>
        <td width="85%" colspan="2" style="border-bottom:solid; border-bottom-width:1px; border-bottom-color:#000;"><strong>Description</strong></td>
        <td width="15%" style="border-bottom:solid; border-bottom-width:1px; border-bottom-color:#000;"><strong>Amount</strong></td>
      </tr>';
	    $subtotal = 0;
		$qinvoiceitems = mysqli_query ( $conn,  "SELECT * FROM tblinvoices_items WHERE invoice_id='".$qinvoicerow['id']."' ORDER BY id ASC" );
		while ( $qinvoiceitemsrow = mysqli_fetch_assoc ( $qinvoiceitems ) )
		{
		  $subtotal += $qinvoiceitemsrow['total'];
		  $html .= '
		  <tr>
			<td style="border-bottom:solid; border-bottom-width:1px; border-bottom-color:#ddd;" colspan="2">'.$qinvoiceitemsrow['description'].'</td>
			<td style="border-bottom:solid; border-bottom-width:1px; border-bottom-color:#ddd;">'.float_to_rand($qinvoiceitemsrow['total']).'</td>
		  </tr>';
		}
	  
	  $html .= '
      <tr>
        <td width="70%">&nbsp;</td>
        <td width="15%" style="border-bottom:solid; border-bottom-width:1px; border-bottom-color:#ddd;">Sub Total</td>
        <td width="15%" style="border-bottom:solid; border-bottom-width:1px; border-bottom-color:#ddd;">'.float_to_rand($subtotal).'</td>
      </tr>
	  <tr>
        <td>&nbsp;</td>
        <td style="border-bottom:solid; border-bottom-width:1px; border-bottom-color:#ddd;">Credit</td>
        <td style="border-bottom:solid; border-bottom-width:1px; border-bottom-color:#ddd;">'.float_to_rand($qinvoicerow['credit']).'</td>
      </tr>
	  <tr>
        <td>&nbsp;</td>
        <td style="border-bottom:solid; border-bottom-width:1px; border-bottom-color:#ddd;">Total Due</td>
        <td style="border-bottom:solid; border-bottom-width:1px; border-bottom-color:#ddd;">'.float_to_rand($qinvoicerow['total']).'</td>
      </tr>
    </table></td>
  </tr>
  
  <tr>
    <td><p>&nbsp;</p>
		<table width="100%" border="0" cellspacing="2" cellpadding="2">
			<tr>
				<th><strong>Transaction Date</strong></th>
				<th><strong>Payment Method</strong></th>
				<th><strong>Amount</strong></th>
			</tr>';
			
			$qtransactions = mysqli_query ( $conn, "SELECT * FROM tbltransactions WHERE client_id='".$qclientrow['id']."' AND invoice_id='".$qinvoicerow['id']."' ORDER BY id DESC" );
			if( mysqli_num_rows( $qtransactions ) == 0 )$html .= '<tr><td colspan="3" style="text-align:center;">No transactions found</td></tr>';
			while ( $qtransactionsrow = mysqli_fetch_assoc ( $qtransactions ) )
			{
			$html .= '<tr>
				<td>'.func_date( $qtransactionsrow['date'] ).' '.$qtransactionsrow['time'].'</td>
				<td>'.func_payment_method( $qtransactionsrow['payment_method'] ).'</td>
				<td>'.float_to_rand($qtransactionsrow['total']).'</td>
			</tr>';
			}
			$html .= '<tr>
				<td style="border-top: solid; border-top-color: #B4B8BC; border-top-width: 1px;">&nbsp;</td>
				<td style="border-top: solid; border-top-color: #B4B8BC; border-top-width: 1px;"><strong>Balance</strong></td>
				<td style="border-top: solid; border-top-color: #B4B8BC; border-top-width: 1px;">'.float_to_rand($qinvoicerow['balance']).'</td>
			</tr>';
		$html .= '</table>
	</td>
  </tr>';
  
  if( $qsettingsrow['comments'] != "" )
  {
  $html .= '<tr>
    <td><p>&nbsp;</p>';
		$html .= '<h4 class="text-themecolor">Comments</h4><font style="font-size:80%">'.nl2br($qsettingsrow['comments']).'</font>';
	$html .= '</td>
  </tr>';
  }
  
$html .= '</table>';


// Print text using writeHTMLCell()
$pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);

// ---------------------------------------------------------

// Close and output PDF document
// This method has several options, check the source code documentation for more information.
$pdf->Output('invoice'.$qinvoicerow['id'].'.pdf', 'I');

//============================================================+
// END OF FILE
//============================================================+


?>