<?php

	# Start the session
	session_start();
	
	if ( !isset ( $_GET ['page'] ) || $_GET ['page'] == "" )
	{
		header ( "Location: index.php?page=main" );
		die ();
	}
	
	require "../config/db.php";
	require "../config/common.php";
	require "../config/functions.php";
	require "../config/logs.php";
	require "../includes/send_mail.php";
	require "../includes/language.php";
	require "../includes/notes.php";
	
	$conn = db_connect();

	if ( $_SERVER ['SERVER_NAME'] == "localhost" )
	{
		$conn_whmcs = mysqli_connect ("localhost", "root", "toor", "digitalzom_digitalz_whmcs");
	}
	else
	{
		$conn_whmcs = mysqli_connect ("localhost", "digitalzom_wuser", "vfManMSVgNMp", "digitalzom_digitalz_whmcs");
		mysqli_query($conn_whmcs, "SET NAMES 'utf8'");
		mysqli_query($conn_whmcs, "SET CHARACTER SET utf8");
		mysqli_query($conn_whmcs, "SET COLLATION_CONNECTION = 'utf8_unicode_ci'");
	}
	
	if ( !is_admin () )
	{
		header("Location: login");
	}
	if ( !file_exists ( "" . $_GET ['page'] . ".php" ) )
	{
		header ( "Location: index.php?page=404" );
		die ();	
	} else {
		require "" . $_GET ['page'] . ".php";
		$ret = page_post ($conn);
		if ( $ret != NULL )
		{
			header ( "Location: " . $ret );
			die ();
		}
		
	}
	$qsettings = mysqli_query ( $conn, "SELECT * FROM tblsettings LIMIT 1" );
    $qsettingsrow = mysqli_fetch_assoc ( $qsettings );
	
	$quser = mysqli_query ( $conn, "SELECT * FROM tblclients WHERE id='".$_SESSION ['AUTH_ID']."' LIMIT 1" );
    $quserrow = mysqli_fetch_assoc ( $quser );
	
	$_SESSION ['language'] = "en_US";
	
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="../images/favicon.png">
    <title><?php echo $qsettingsrow['title']; ?></title>
    <!-- Bootstrap Core CSS -->
    <link href="../vendors/bootstrap/css/bootstrap.min.css" rel="stylesheet">
	<link href="../vendors/datatables/media/css/dataTables.bootstrap4.css" rel="stylesheet" type="text/css" >
	<!--alerts CSS -->
    <link href="../vendors/sweetalert/sweetalert.css" rel="stylesheet" type="text/css">
	<!-- Date picker plugins css -->
	<link href="../vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" rel="stylesheet" type="text/css" />
	<!-- Daterange picker plugins css -->
	<link href="../vendors/timepicker/bootstrap-timepicker.min.css" rel="stylesheet">
	<link href="../vendors/daterangepicker/daterangepicker.css" rel="stylesheet">

    <!-- Custom CSS -->
    <link href="../css/style-admin.css" rel="stylesheet">
    <!-- You can change the theme colors from here -->
    <link href="../css/colors/blue-admin.css" id="theme" rel="stylesheet">
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
    <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
	<![endif]-->
	
	<!-- Custom Theme Style -->
    <link href="../css/custom.css" rel="stylesheet">

    <?php if ( function_exists('page_config') ){page_config($conn);} ?>
</head>

<body class="fix-header fix-sidebar card-no-border">
	<button onclick="topFunction()" id="myTopBtn" title="Go to top">Back To Top</button>
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" /> </svg>
    </div>
    <div id="main-wrapper">
        <header class="topbar">
            <nav class="navbar top-navbar navbar-expand-md navbar-light">
                <div class="navbar-header">
                    <a class="navbar-brand hidden-xs-down" href="index.php">
                        <b>
                        <img src="../images/logo.jpg" alt="homepage" class="dark-logo" width="200px" />
						</b> 
					</a>
                </div>
                <div class="navbar-collapse">
                    <ul class="navbar-nav mr-auto mt-md-0 ">
                        <!-- This is  -->
                        <li class="nav-item"> <a class="nav-link nav-toggler hidden-md-up text-muted waves-effect waves-dark" href="javascript:void(0)"><i class="ti-menu"></i></a> </li>
                        <li class="nav-item"> <a class="nav-link sidebartoggler hidden-sm-down text-muted waves-effect waves-dark" href="javascript:void(0)"><i class="icon-arrow-left-circle"></i></a> </li>
						
                    </ul>
                    <ul class="navbar-nav my-lg-0">
                        
						<li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle text-muted waves-effect waves-dark" href="" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							<?php
								if ( $quserrow['thumbnail'] != "" ) 
								{
									echo "<img src=\"../media/".$quserrow['id']."/profile/".$quserrow['thumbnail']."\" alt=\"User\" class=\"profile-pic\">";
								}
								else
								{
									echo "<img src=\"../images/user.png\" alt=\"User\" class=\"profile-pic\">";
								}
							?>
							</a>
                            <div class="dropdown-menu dropdown-menu-right animated flipInY">
                                <ul class="dropdown-user">
                                    <li>
                                        <div class="dw-user-box">
                                            <div class="u-img">
											<?php
												if ( $quserrow['thumbnail'] != "" ) 
												{
													echo "<img src=\"../media/".$quserrow['id']."/profile/".$quserrow['thumbnail']."\" alt=\"User\">";
												}
												else
												{
													echo "<img src=\"../images/user.png\" alt=\"User\">";
												}
											?>
											</div>
                                            <div class="u-text">
                                                <h4><?php echo $quserrow['name']." ".$quserrow['surname']; ?></h4>
                                                <p class="text-muted"><?php echo $quserrow['email']; ?></p>
												<a href="index.php?page=settings_administrators&func=profile&id=<?php echo $quserrow['id']; ?>" class="btn btn-rounded btn-danger btn-sm">View Profile</a>
											</div>
                                        </div>
                                    </li>
                                    <li role="separator" class="divider"></li>
									<li><a href="index.php?page=settings_administrators&func=profile&id=<?php echo $quserrow['id']; ?>"><i class="ti-user"></i> My Profile</a></li>
                                    <li role="separator" class="divider"></li>
                                    <li><a href="logout.php?func=logout"><i class="fa fa-power-off"></i> Logout</a></li>
                                </ul>
                            </div>
                        </li>
                    </ul>
                </div>
            </nav>
        </header>
        <aside class="left-sidebar">
            <!-- Sidebar scroll-->
            <div class="scroll-sidebar">
                <!-- Sidebar navigation-->
                <nav class="sidebar-nav">
                    <ul id="sidebarnav">
                        
                        <li class="<?php if ( $_GET ['page'] == "main" )echo "active"; ?>"><a href="index.php"><i class="fa fa-home"></i> Dashboard</a> </li>    
						
                        <?php
							$menu_query_tblhosting_active = mysqli_query ( $conn_whmcs, "SELECT * FROM tblwhmdomains WHERE suspended='' AND owner='zwz87' ORDER BY domain ASC" );
							$count_menu_query_tblhosting_active = 0;
							while ( $menu_q_tblhosting_active = mysqli_fetch_assoc ( $menu_query_tblhosting_active ) )
							{
								$menu_query_whmcstblhosting_active = "SELECT * FROM tblhosting WHERE domain='".$menu_q_tblhosting_active['domain']."' AND packageid in (3,50,32,51,49,52,53,80,33,34) AND domainstatus<>'Active'";
								$count_query_whmcstblhosting_active = mysqli_num_rows( mysqli_query ( $conn_whmcs, $menu_query_whmcstblhosting_active ) );
								if($count_query_whmcstblhosting_active == 1) $count_menu_query_tblhosting_active++;
							}

							$menu_query_tblhosting_inactive = mysqli_query ( $conn_whmcs, "SELECT * FROM tblwhmdomains WHERE suspended='1' AND owner='zwz87' ORDER BY domain ASC" );
							$count_menu_query_tblhosting_inactive = 0;
							while ( $menu_q_tblhosting_inactive = mysqli_fetch_assoc ( $menu_query_tblhosting_inactive ) )
							{
								$menu_query_whmcstblhosting_inactive = "SELECT * FROM tblhosting WHERE domain='".$menu_q_tblhosting_inactive['domain']."' AND packageid in (3,50,32,51,49,52,53,80,33,34) AND domainstatus<>'Suspended'";
								$count_query_whmcstblhosting_inactive = mysqli_num_rows( mysqli_query ( $conn_whmcs, $menu_query_whmcstblhosting_inactive ) );
								if($count_query_whmcstblhosting_inactive == 1) $count_menu_query_tblhosting_inactive++;
							}
						?>


                        <li class="<?php if ( $_GET ['page'] == "hosting_issues" )echo "active"; ?> <?php if( !admin_role($_SESSION ['AUTH_ID'], 11) )echo "hide"; ?>">
                            <a class="has-arrow <?php if ( $_GET ['page'] == "whmcs_accounts" )echo "active"; ?>" href="#" aria-expanded="false"><i class="mdi mdi-auto-fix"></i><span class="hide-menu">Server Maintenance</span></a>
                            <ul aria-expanded="false" class="collapse">
								<li><a class="<?php if ( $_GET ['page'] == "server_maintenance" && $_GET ['status'] == "Inactive" )echo "active"; ?>" href="index.php?page=server_maintenance&status=Inactive">Inactive <span class="label label-rounded label-danger"><?php echo $count_menu_query_tblhosting_inactive; ?></span></a></li>
								<li><a href="#">Bandwidth Issue <span class="label label-rounded label-danger">0</span></a></li>
								<li><a href="#">Disk Space <span class="label label-rounded label-danger">0</span></a></li>
								<li><a class="<?php if ( $_GET ['page'] == "server_maintenance" && $_GET ['status'] == "Active" )echo "active"; ?>" href="index.php?page=server_maintenance&status=Active">Active <span class="label label-rounded label-warning"><?php echo $count_menu_query_tblhosting_active; ?></span></a></li>
								<li><a href="#">Packages <span class="label label-rounded label-warning">0</span></a></li>
								<li><a href="#">Parked Accounts <span class="label label-rounded label-warning">0</span></a></li>
								<li><a href="#">Exception List <span class="label label-rounded label-success">0</a></li>
							</ul>
                        </li>

                        <li class="<?php if ( $_GET ['page'] == "hosting_issues" )echo "active"; ?> <?php if( !admin_role($_SESSION ['AUTH_ID'], 11) )echo "hide"; ?>">
                            <a class="has-arrow <?php if ( $_GET ['page'] == "whmcs_accounts" )echo "active"; ?>" href="#" aria-expanded="false"><i class="fab fa-whmcs"></i><span class="hide-menu">WHMCS Maintenance</span></a>
                            <ul aria-expanded="false" class="collapse">
								<li><a href="#">Invoice Issues <span class="label label-rounded label-info">0</span></a></li>
							</ul>
                        </li>

                        <li class="<?php if ( $_GET ['page'] == "hosting_issues" )echo "active"; ?> <?php if( !admin_role($_SESSION ['AUTH_ID'], 11) )echo "hide"; ?>">
                            <a class="has-arrow <?php if ( $_GET ['page'] == "whmcs_accounts" )echo "active"; ?>" href="#" aria-expanded="false"><i class="fab fa-chrome"></i><span class="hide-menu">Domains Maintenance</span></a>
                            <ul aria-expanded="false" class="collapse">
								<li class="<?php if ( $_GET ['page'] == "whmcs_accounts" && $_GET ['status'] == "all" )echo "active"; ?>"><a href="#">View All / Import <span class="label label-rounded label-info">0</span></a></li>
								<li class="<?php if ( $_GET ['page'] == "whmcs_accounts" && $_GET ['status'] == "all" )echo "active"; ?>"><a href="#">Contact Update <span class="label label-rounded label-info">0</span></a></li>
								<li class="<?php if ( $_GET ['page'] == "whmcs_accounts" && $_GET ['status'] == "all" )echo "active"; ?>"><a href="#">Pending Delete <span class="label label-rounded label-info">0</span></a></li>
								<li class="<?php if ( $_GET ['page'] == "whmcs_accounts" && $_GET ['status'] == "all" )echo "active"; ?>"><a href="#">Redemption <span class="label label-rounded label-info">0</span></a></li>
							</ul>
                        </li>

						<?php
						$p_all = "SELECT * FROM tblhosting WHERE packageid in (3,50,32,51,49,52,53,80,33,34) ";
						$qproducts_all = mysqli_query ( $conn_whmcs, $p_all );
						
						$p_active = "SELECT * FROM tblhosting WHERE packageid in (3,50,32,51,49,52,53,80,33,34) AND domainstatus='Active' ";
						$qproducts_active = mysqli_query ( $conn_whmcs, $p_active );
						
						$p_pending = "SELECT * FROM tblhosting WHERE packageid in (3,50,32,51,49,52,53,80,33,34) AND domainstatus='Pending' ";
						$qproducts_pending = mysqli_query ( $conn_whmcs, $p_pending );
						
						$p_suspended = "SELECT * FROM tblhosting WHERE packageid in (3,50,32,51,49,52,53,80,33,34) AND domainstatus='Suspended' ";
						$qproducts_suspended = mysqli_query ( $conn_whmcs, $p_suspended );
						
						$p_cancelled = "SELECT * FROM tblhosting WHERE packageid in (3,50,32,51,49,52,53,80,33,34) AND domainstatus='Cancelled' ";
						$qproducts_cancelled = mysqli_query ( $conn_whmcs, $p_cancelled );

						$p_terminated = "SELECT * FROM tblhosting WHERE packageid in (3,50,32,51,49,52,53,80,33,34) AND domainstatus='Terminated' ";
						$qproducts_terminated = mysqli_query ( $conn_whmcs, $p_terminated );
						?>

						<li class="<?php if ( $_GET ['page'] == "whmcs_accounts" )echo "active"; ?> <?php if( !admin_role($_SESSION ['AUTH_ID'], 11) )echo "hide"; ?>">
                            <a class="has-arrow <?php if ( $_GET ['page'] == "whmcs_accounts" )echo "active"; ?>" href="#" aria-expanded="false"><i class="fab fa-whmcs"></i><span class="hide-menu">WHMCS Accounts</span></a>
                            <ul aria-expanded="false" class="collapse">
								<li class="<?php if ( $_GET ['page'] == "whmcs_accounts" && $_GET ['status'] == "all" )echo "active"; ?>"><a href="index.php?page=whmcs_accounts&status=All">View All <span class="label label-rounded label-info"><?php echo mysqli_num_rows($qproducts_all); ?></span></a></li>
								<li class="<?php if ( $_GET ['page'] == "whmcs_accounts" && $_GET ['status'] == "active" )echo "active"; ?>"><a href="index.php?page=whmcs_accounts&status=Active">Active <span class="label label-rounded label-success"><?php echo mysqli_num_rows($qproducts_active); ?></span></a></li>
								<li class="<?php if ( $_GET ['page'] == "whmcs_accounts" && $_GET ['status'] == "pending" )echo "active"; ?>"><a href="index.php?page=whmcs_accounts&status=Pending">Pending <span class="label label-rounded label-warning"><?php echo mysqli_num_rows($qproducts_pending); ?></span></a></li>
								<li class="<?php if ( $_GET ['page'] == "whmcs_accounts" && $_GET ['status'] == "suspended" )echo "active"; ?>"><a href="index.php?page=whmcs_accounts&status=Suspended">Suspended <span class="label label-rounded label-danger"><?php echo mysqli_num_rows($qproducts_suspended); ?></span></a></li>
								<li class="<?php if ( $_GET ['page'] == "whmcs_accounts" && $_GET ['status'] == "cancelled" )echo "active"; ?>"><a href="index.php?page=whmcs_accounts&status=Cancelled">Cancelled <span class="label label-rounded label-secondary"><?php echo mysqli_num_rows($qproducts_cancelled); ?></span></a></li>
								<li class="<?php if ( $_GET ['page'] == "whmcs_accounts" && $_GET ['status'] == "terminated" )echo "active"; ?>"><a href="index.php?page=whmcs_accounts&status=Terminated">Terminated <span class="label label-rounded label-primary"><?php echo mysqli_num_rows($qproducts_terminated); ?></span></a></li>
								<li><a href="#">Packages</a></li>
							</ul>
                        </li>
						<?php
                        $p_server_all = "SELECT * FROM tblwhmdomains WHERE owner='zwz87'";
						$q_server_all = mysqli_query ( $conn_whmcs, $p_server_all );

                        $p_server_active = "SELECT * FROM tblwhmdomains WHERE owner = 'zwz87' AND suspended in (NULL,'')";
						$q_server_active = mysqli_query ( $conn_whmcs, $p_server_active );
						
						$p_server_suspended = "SELECT * FROM tblwhmdomains WHERE owner = 'zwz87' AND suspended = '1' ";
						$q_server_suspended = mysqli_query ( $conn_whmcs, $p_server_suspended );

						$p_parkeddomains = "SELECT * FROM tblparkeddomains";
						$menu_count_parkeddomains = mysqli_query ( $conn, $p_parkeddomains );
						?>

                        <li class="<?php if ( $_GET ['page'] == "server_accounts" )echo "active"; ?> <?php if( !admin_role($_SESSION ['AUTH_ID'], 11) )echo "hide"; ?>">
                            <a class="has-arrow <?php if ( $_GET ['page'] == "server_accounts" )echo "active"; ?>" href="#" aria-expanded="false"><i class="fas fa-laptop"></i><span class="hide-menu">Server Accounts</span></a>
                            <ul aria-expanded="false" class="collapse">
								<li class="<?php if ( $_GET ['page'] == "whmcs_accounts" && $_GET ['status'] == "All" )echo "active"; ?>"><a href="index.php?page=server_accounts&status=All">View All <span class="label label-rounded label-info"><?php echo mysqli_num_rows($q_server_all); ?></span></a></li>
								<li class="<?php if ( $_GET ['page'] == "whmcs_accounts" && $_GET ['status'] == "Active" )echo "active"; ?>"><a href="index.php?page=server_accounts&status=Active">DZ Active <span class="label label-rounded label-success"><?php echo mysqli_num_rows($q_server_active); ?></span></a></li>
								<li class="<?php if ( $_GET ['page'] == "whmcs_accounts" && $_GET ['status'] == "Suspended" )echo "active"; ?>"><a href="index.php?page=server_accounts&status=Suspended">DZ Suspended <span class="label label-rounded label-danger"><?php echo mysqli_num_rows($q_server_suspended); ?></span></a></li>
								<li class="<?php if ( $_GET ['page'] == "parkeddomains" )echo "active"; ?>"><a href="index.php?page=parkeddomains">Parked Domains <span class="label label-rounded label-success"><?php echo mysqli_num_rows($menu_count_parkeddomains); ?></span></a></li>

							</ul>
                        </li>
					
                        <li class="<?php if ( $_GET ['page'] == "settings" || $_GET ['page'] == "settings_administrators" || $_GET ['page'] == "settings_email" 
											  || $_GET ['page'] == "settings_notifications" || $_GET ['page'] == "settings_payments" || $_GET ['page'] == "settings_title"  
											  || $_GET ['page'] == "settings_gender" || $_GET ['page'] == "settings_sales_call_logs" || $_GET ['page'] == "settings_support_call_logs" || $_GET ['page'] == "settings_support_querries" || $_GET ['page'] == "settings_sales_pitches" 
											  || $_GET ['page'] == "settings_commission_structure" || $_GET ['page'] == "settings_benefits" || $_GET ['page'] == "settings_import" || $_GET ['page'] == "settings_roles"   
											  || $_GET ['page'] == "settings_documents" )echo "active"; ?> <?php if( !admin_role($_SESSION ['AUTH_ID'], 19) )echo "hide"; ?>">
                            <a class="has-arrow" href="#" aria-expanded="false"><i class="fa fa-cog"></i><span class="hide-menu"> Settings</span></a>
                            <ul aria-expanded="false" class="collapse">
								<li class="<?php if ( $_GET ['page'] == "settings")echo "active"; ?>"><a href="index.php?page=settings">General Settings</a></li>
                                <li class="<?php if ( $_GET ['page'] == "settings_administrators" )echo "active"; ?>"><a href="index.php?page=settings_administrators">Administrators</a></li>
								<li class="<?php if ( $_GET ['page'] == "settings_roles" )echo "active"; ?>"><a href="index.php?page=settings_roles">Administrator Roles</a></li>
                            </ul>
                        </li>
						
                    </ul>
                </nav>
            </div>
        </aside>
        <div class="page-wrapper">
            <div class="container-fluid">
                <div class="row page-titles">
                    <div class="col-md-12 col-8 align-self-center">
						<?php 
						if ( isset( $_GET['save'] ) )fetch_note ( "save" );
						if ( isset( $_GET['import'] ) )fetch_note ( "import" );
						if ( isset( $_GET['send'] ) )fetch_note ( "send" );
						if ( isset( $_GET['upload'] ) )fetch_note ( "upload" );
						if ( isset( $_GET['exceedtotal'] ) )fetch_note ( "exceedtotal" );
						if ( isset( $_GET['creditexceedtotal'] ) )fetch_note ( "creditexceedtotal" );
						if ( isset( $_GET['exceedbalance'] ) )fetch_note ( "exceedbalance" );
						?>
                    </div>
                </div>
                <?php
				page_main($conn);
				?> 
            </div>
            <footer class="footer">
				<div class="text-md-right">
                	Copyright &copy; <?php echo date("Y"); ?> <?php echo $qsettingsrow['title']; ?>
				</div>
            </footer>
        </div>
    </div>
   
    <!-- All Jquery -->
    <script src="../vendors/jquery/jquery.min.js"></script>
    <!-- Bootstrap tether Core JavaScript -->
    <script src="../vendors/bootstrap/js/popper.min.js"></script>
    <script src="../vendors/bootstrap/js/bootstrap.min.js"></script>
    <!-- slimscrollbar scrollbar JavaScript -->
    <script src="../js/jquery.slimscroll-admin.js"></script>
    <!--Wave Effects -->
    <script src="../js/waves.js"></script>
    <!--Menu sidebar -->
    <script src="../js/sidebarmenu.js"></script>
    <!--stickey kit -->
    <script src="../vendors/sticky-kit-master/dist/sticky-kit.js"></script>
	<!-- This is data table -->
    <script src="../vendors/datatables/datatables.min.js"></script>
	<!-- start - This is for export functionality only -->
    <script src="https://cdn.datatables.net/buttons/1.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.2.2/js/buttons.flash.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/2.5.0/jszip.min.js"></script>
    <script src="https://cdn.rawgit.com/bpampuch/pdfmake/0.1.18/build/pdfmake.min.js"></script>
    <script src="https://cdn.rawgit.com/bpampuch/pdfmake/0.1.18/build/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.2.2/js/buttons.print.min.js"></script>
    <!-- end - This is for export functionality only -->
	<!-- Sweet-Alert  -->
    <script src="../vendors/sweetalert/sweetalert.min.js"></script>
    <script src="../vendors/sweetalert/jquery.sweet-alert.custom.js"></script>
	<script src="../js/alerts.js"></script>
	<!-- Date Picker Plugin -->
	<script src="../vendors/moment/moment.js"></script>
	<script src="../vendors/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
	<!-- Date range Plugin JavaScript -->
	<script src="../vendors/timepicker/bootstrap-timepicker.min.js"></script>
	<script src="../vendors/daterangepicker/daterangepicker.js"></script>
	<script src="../vendors/daterangepicker/dates.js"></script>

    <!--Custom JavaScript -->
    <script src="../js/custom-admin.min.js"></script>
	<script src="../js/extras.js"></script>
	<script src="../js/bulk-actions.js"></script>
	
	<script>
   
        $(document).ready(function() {
		
			$('#myTable').DataTable( {
				dom: "Bfrtip",
				  buttons: [
					{
					  extend: "copyHtml5",
					},
					{
					  extend: "excelHtml5",
					  exportOptions: {
						columns: "thead th:not(.noExport)"
					  }
					},
					
					{
					  extend: "pdfHtml5",
					},
					{
					  extend: "print",
					  customize: function ( win ) {
							$(win.document.body)
								.css( 'font-size', '10pt' )
								.css( 'background', '#ffffff' )
		 
							$(win.document.body).find( 'table' )
								.addClass( 'compact' )
								.removeClass( 'table-striped' )
								.removeClass( 'jambo_table' )
								.css( 'font-size', 'inherit' );
						}
					},
					{
					  extend: "pageLength",
					},
				  ],
				<?php
				if($_GET['page'] == "reports_stationery")
				{
					?>
					"ordering": false,
					<?php
				}
				else
				{
					?>
					"ordering": true,
					<?php
				}
				?>
				<?php
				if($_GET['page'] == "commission" || $_GET['page'] == "settings_commission_structure" || $_GET['page'] == "settings_role_groups" || $_GET['page'] == "settings_grades" || $_GET['page'] == "products" || $_GET['page'] == "stationery")
				{
					?>
					'order': [[ 0, 'asc' ]],
					<?php
				}
				else if($_GET['page'] == "support_queries" || $_GET['page'] == "support_call_logs" || $_GET['page'] == "log_email" || $_GET['page'] == "log_activity" || $_GET['page'] == "invoices" || ($_GET['page'] == "parents" && isset($_GET['func'])) || ($_GET['page'] == "registrants" && $_GET['func'] == "emails") || ($_GET['page'] == "reps" && $_GET['func'] == "emails") || ($_GET['page'] == "registrants" && $_GET['func'] == "credits" ) 
				|| $_GET['page'] == "registrants" || ($_GET['page'] == "registrants" && $_GET['func'] == "sales_call_logs") || ($_GET['page'] == "registrants" && $_GET['func'] == "support_call_logs") || ($_GET['page'] == "registrants" && $_GET['func'] == "invoices") || ($_GET['page'] == "registrants" && $_GET['func'] == "support_queries") || ($_GET['page'] == "registrants" && $_GET['func'] == "benefits") )
				{
					?>
					'order': [[ 0, 'desc' ]],
					<?php
				}
				else if($_GET['page'] == "parents" && !isset($_GET['func']) || $_GET['page'] == "registrants")
				{
					?>
					'order': [[ 2, 'asc' ]],
					<?php
				}
				else if($_GET['page'] == "whmcs_accounts")
				{
					?>
					'order': [[ 0, 'asc' ]],
					<?php
				}
				else if($_GET['page'] == "server_accounts")
				{
					?>
					'order': [[ 0, 'asc' ]],
					<?php
				}
				else if($_GET['page'] == "settings_import")
				{
					?>
					'order': [[ 1, 'desc' ]],
					<?php
				}
				else
				{
					?>
					'order': [[ 1, 'asc' ]],
					<?php
				}
				?>
				"iDisplayLength": 100,
				"lengthMenu": [[25, 50, 100, 200, 500], [25, 50, 100, 200, 500]]
			} );
			
		} );
    	$('.buttons-copy, .buttons-csv, .buttons-print, .buttons-pdf, .buttons-excel').addClass('btn btn-secondary mr-1');
	</script>
	
	<!-- Autocomplete Search -->
    <script src="../config/typeahead.js"></script>    
	<script>
	$(document).ready(function () {
        $('#autocomplete').typeahead({
            source: function (query, result) {
                $.ajax({
                    url: "../includes/autocomplete.php",
                    dataType: "json",
                    success: function (data) {
						result($.map(data, function (item) {
							return item;
                        }));
                    }
                });
            }
        });
    });
	
	</script>
	
	
    <?php if ( function_exists('page_config_footer') ){page_config_footer($conn);} ?>
</body>

</html>
