<?php

	# Start the session
	session_start();
	
	if ( !isset ( $_GET ['page'] ) || $_GET ['page'] == "" )
	{
		header ( "Location: index.php?page=main" );
		die ();
	}
	
	require "../config/db.php";
	require "../config/common.php";
	require "../config/functions.php";
	require "../config/logs.php";
	require "../includes/send_mail.php";
	require "../includes/language.php";
	require "../includes/notes.php";
	
	$conn = db_connect();
	
	if ( !is_admin () )
	{
		header("Location: login");
	}
	if ( !file_exists ( "" . $_GET ['page'] . ".php" ) )
	{
		header ( "Location: index.php?page=404" );
		die ();	
	} else {
		require "" . $_GET ['page'] . ".php";
		$ret = page_post ($conn);
		if ( $ret != NULL )
		{
			header ( "Location: " . $ret );
			die ();
		}
		
	}
	$qsettings = mysqli_query ( $conn, "SELECT * FROM tblsettings LIMIT 1" );
    $qsettingsrow = mysqli_fetch_assoc ( $qsettings );
	
	$quser = mysqli_query ( $conn, "SELECT * FROM tblclients WHERE id='".$_SESSION ['AUTH_ID']."' LIMIT 1" );
    $quserrow = mysqli_fetch_assoc ( $quser );
	
	$_SESSION ['language'] = "en_US";
	
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="../images/favicon.png">
    <title><?php echo $qsettingsrow['title']; ?></title>
    <!-- Bootstrap Core CSS -->
    <link href="../vendors/bootstrap/css/bootstrap.min.css" rel="stylesheet">
	<link href="../vendors/datatables/media/css/dataTables.bootstrap4.css" rel="stylesheet" type="text/css" >
	<!--alerts CSS -->
    <link href="../vendors/sweetalert/sweetalert.css" rel="stylesheet" type="text/css">
	<!-- Date picker plugins css -->
	<link href="../vendors/bootstrap-datepicker/bootstrap-datepicker.min.css" rel="stylesheet" type="text/css" />
	<!-- Daterange picker plugins css -->
	<link href="../vendors/timepicker/bootstrap-timepicker.min.css" rel="stylesheet">
	<link href="../vendors/daterangepicker/daterangepicker.css" rel="stylesheet">

    <!-- Custom CSS -->
    <link href="../css/style-admin.css" rel="stylesheet">
    <!-- You can change the theme colors from here -->
    <link href="../css/colors/blue-admin.css" id="theme" rel="stylesheet">
    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
    <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
	<![endif]-->
	
	<!-- Custom Theme Style -->
    <link href="../css/custom.css" rel="stylesheet">    
    
    <?php if ( function_exists('page_config') ){page_config($conn);} ?>
</head>

<body class="fix-header fix-sidebar card-no-border">
	<button onclick="topFunction()" id="myTopBtn" title="Go to top">Back To Top</button>
    <div class="preloader">
        <svg class="circular" viewBox="25 25 50 50">
            <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10" /> </svg>
    </div>
    <div id="main-wrapper">
        <header class="topbar">
            <nav class="navbar top-navbar navbar-expand-md navbar-light">
                <div class="navbar-header">
                    <a class="navbar-brand hidden-xs-down" href="index.php">
                        <b>
                        <img src="../images/logo.png" alt="homepage" class="dark-logo" width="200px" />
						</b> 
					</a>
                </div>
                <div class="navbar-collapse">
                    <ul class="navbar-nav mr-auto mt-md-0 ">
                        <!-- This is  -->
                        <li class="nav-item"> <a class="nav-link nav-toggler hidden-md-up text-muted waves-effect waves-dark" href="javascript:void(0)"><i class="ti-menu"></i></a> </li>
                        <li class="nav-item"> <a class="nav-link sidebartoggler hidden-sm-down text-muted waves-effect waves-dark" href="javascript:void(0)"><i class="icon-arrow-left-circle"></i></a> </li>
						
                        <li class="nav-item dropdown <?php if( !admin_role($_SESSION ['AUTH_ID'], 9) )echo "hide"; ?>">
                            <?php
							$qsupport_notice = mysqli_query ( $conn, "SELECT * FROM tblclients_support_queries WHERE open='' ORDER BY id DESC" );
							?>
							<a class="nav-link dropdown-toggle waves-effect waves-dark" href="" id="2" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> <i class="mdi mdi-email notice_hover"></i>
                                <?php
								if( mysqli_num_rows( $qsupport_notice ) > 0 )
								{
								$support_message_count = mysqli_num_rows($qsupport_notice);
								?>
								<div class="notify"> <span class="heartbit"></span> <span class="point"></span> </div>
								<?php
								}
								else
								{
								$support_message_count = "no";
								}
								?>
                            </a>
                            <div class="dropdown-menu mailbox animated bounceInDown" aria-labelledby="2">
								<ul>
                                    <li>
                                        <div class="drop-title">You have <?php echo $support_message_count; ?> new messages</div>
                                    </li>
                                    <li>
                                        <div class="message-center">
                                            <?php
											while ($qsupport_noticerow = mysqli_fetch_assoc ( $qsupport_notice ))
											{
											$qreplies = mysqli_query ( $conn, "SELECT MIN(id), parent_id, author_id, sender, sender_address FROM tblclients_support_queries_replies WHERE parent_id='".$qsupport_noticerow['id']."' LIMIT 1");
											$qrepliesrow = mysqli_fetch_assoc( $qreplies );

											if( $qsupport_noticerow['client_id'] != 0 )
											{
												$qauthor = mysqli_query ( $conn, "SELECT * FROM tblclients WHERE id='".$qsupport_noticerow['client_id']."' LIMIT 1" );
												$qauthorrow = mysqli_fetch_assoc ( $qauthor );
											}
											else if( $qsupport_noticerow['author_id'] != 0 )
											{
												$qauthor = mysqli_query ( $conn, "SELECT * FROM tblclients WHERE id='".$qsupport_noticerow['author_id']."' LIMIT 1" );
												$qauthorrow = mysqli_fetch_assoc ( $qauthor );
											}
											else
											{
												$qauthor = mysqli_query ( $conn, "SELECT * FROM tblclients WHERE adminrole='user' AND email='".$qrepliesrow['sender_address']."' LIMIT 1" );
												$qauthorrow = mysqli_fetch_assoc ( $qauthor );
											}
											?>
											<!-- Message -->
                                            <a href="index.php?page=support_queries&func=view&id=<?php echo $qsupport_noticerow['id']; ?>">
                                                <div class="user-img"> <img src="../images/user.png" alt="user" class="img-circle"> <span class="profile-status online float-right"></span> </div>
                                                <div class="mail-contnet">
                                                    <h5>
													<?php 
													if(mysqli_num_rows($qauthor) > 0)
													{
														echo $qauthorrow['name']." ".$qauthorrow['surname'];
													}
													else
													{
														echo $qrepliesrow['sender'];
													}
													?>
													</h5> <span class="mail-desc"><?php echo $qsupport_noticerow['subject']; ?></span> <span class="time"><?php echo func_date($qsupport_noticerow['date'])." ".$qsupport_noticerow['time']; ?></span> </div>
                                            </a>
                                            <!-- Message -->
											<?php
											}
											?>
                                        </div>
                                    </li>
                                    <li>
                                        <a class="nav-link text-center" href="index.php?page=support_queries&list=all"> <strong>See all Support Emails</strong> <i class="fa fa-angle-right"></i> </a>
                                    </li>
                                </ul>
                            </div>
                        </li>
						
                    </ul>
                    <ul class="navbar-nav my-lg-0">
                        <li class="nav-item hidden-sm-down">
                            <form class="app-search" id="form_complete" name="form_complete" action="index.php?page=search" method="post">
                                <input type="text" class="form-control typeahead" name="autocomplete" id="autocomplete" placeholder="Search for..." autocomplete="off"> <a class="srh-btn"><i class="ti-search"></i></a> 
							</form>
                        </li>
						<li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle text-muted waves-effect waves-dark" href="" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
							<?php
								if ( $quserrow['thumbnail'] != "" ) 
								{
									echo "<img src=\"../media/".$quserrow['id']."/profile/".$quserrow['thumbnail']."\" alt=\"User\" class=\"profile-pic\">";
								}
								else
								{
									echo "<img src=\"../images/user.png\" alt=\"User\" class=\"profile-pic\">";
								}
							?>
							</a>
                            <div class="dropdown-menu dropdown-menu-right animated flipInY">
                                <ul class="dropdown-user">
                                    <li>
                                        <div class="dw-user-box">
                                            <div class="u-img">
											<?php
												if ( $quserrow['thumbnail'] != "" ) 
												{
													echo "<img src=\"../media/".$quserrow['id']."/profile/".$quserrow['thumbnail']."\" alt=\"User\">";
												}
												else
												{
													echo "<img src=\"../images/user.png\" alt=\"User\">";
												}
											?>
											</div>
                                            <div class="u-text">
                                                <h4><?php echo $quserrow['name']." ".$quserrow['surname']; ?></h4>
                                                <p class="text-muted"><?php echo $quserrow['email']; ?></p>
												<a href="index.php?page=settings_administrators&func=profile&id=<?php echo $quserrow['id']; ?>" class="btn btn-rounded btn-danger btn-sm">View Profile</a>
											</div>
                                        </div>
                                    </li>
                                    <li role="separator" class="divider"></li>
									<li><a href="index.php?page=settings_administrators&func=profile&id=<?php echo $quserrow['id']; ?>"><i class="ti-user"></i> My Profile</a></li>
                                    <li role="separator" class="divider"></li>
                                    <li><a href="logout.php?func=logout"><i class="fa fa-power-off"></i> Logout</a></li>
                                </ul>
                            </div>
                        </li>
                    </ul>
                </div>
            </nav>
        </header>
        <aside class="left-sidebar">
            <!-- Sidebar scroll-->
            <div class="scroll-sidebar">
                <!-- Sidebar navigation-->
                <nav class="sidebar-nav">
                    <ul id="sidebarnav">
                        <li class="<?php if ( $_GET ['page'] == "main" )echo "active"; ?>"><a href="index.php"><i class="fa fa-home"></i> Dashboard Screen</a> </li>    
						<li class="<?php if ( $_GET ['page'] == "registrants" )echo "active"; ?>"><a href="index.php?page=registrants"><i class="fa fa-users"></i> Members</a> </li>    
						
						<li class="<?php if ( $_GET ['page'] == "companies" )echo "active"; ?> <?php if( !admin_role($_SESSION ['AUTH_ID'], 5) )echo "hide"; ?>"><a href="index.php?page=companies"><i class="fa fa-building"></i> Companies</a></li> 
						
						<li class="<?php if ( $_GET ['page'] == "sales_call_logs" )echo "active"; ?> <?php if( !admin_role($_SESSION ['AUTH_ID'], 7) )echo "hide"; ?>">
                            <a class="has-arrow <?php if ( $_GET ['page'] == "sales_call_logs" )echo "active"; ?>" href="#" aria-expanded="false"><i class="fa fas fa-tty"></i><span class="hide-menu"> Sales Call Logs</span></a>
                            <ul aria-expanded="false" class="collapse">
								<?php
								$qsales_logs = mysqli_query($conn, "SELECT * FROM tblsettings_sales_call_logs ORDER BY sort ASC");
								while( $qsales_logsrow = mysqli_fetch_assoc( $qsales_logs ) )
								{
								$q = "SELECT * FROM tblclients_sales_calls WHERE department='".$qsales_logsrow['id']."' ";
								if( $_SESSION ['AUTH_ROLE_ID'] == 2 )$q .= "AND author_id='".$_SESSION ['AUTH_ID']."' ";
								$qcount_sales_logs = mysqli_query($conn, $q);
								?>
									<li class="<?php if ( $_GET ['page'] == "sales_call_logs" && $_GET ['view'] == $qsales_logsrow['id'] )echo "active"; ?>"><a href="index.php?page=sales_call_logs&view=<?php echo $qsales_logsrow['id']; ?>"><?php echo $qsales_logsrow['title']; ?> <span class="label label-rounded label-secondary"><?php echo mysqli_num_rows($qcount_sales_logs); ?></span></a></li>
								<?php
								}
								?>
							</ul>
                        </li>
						
						<li class="<?php if ( $_GET ['page'] == "support_call_logs" )echo "active"; ?> <?php if( !admin_role($_SESSION ['AUTH_ID'], 8) )echo "hide"; ?>">
                            <a class="has-arrow <?php if ( $_GET ['page'] == "support_call_logs" )echo "active"; ?>" href="#" aria-expanded="false"><i class="fa fas fa-phone"></i><span class="hide-menu"> Support Call Logs</span></a>
                            <ul aria-expanded="false" class="collapse">
								<?php
								$qsupport_logs = mysqli_query($conn, "SELECT * FROM tblsettings_support_call_logs ORDER BY sort ASC");
								while( $qsupport_logsrow = mysqli_fetch_assoc( $qsupport_logs ) )
								{
								$qcount_support_logs = mysqli_query($conn, "SELECT id FROM tblclients_support_calls WHERE department='".$qsupport_logsrow['id']."'");
								?>
									<li class="<?php if ( $_GET ['page'] == "support_call_logs" && $_GET ['view'] == $qsupport_logsrow['id'] )echo "active"; ?>"><a href="index.php?page=support_call_logs&view=<?php echo $qsupport_logsrow['id']; ?>"><?php echo $qsupport_logsrow['title']; ?> <span class="label label-rounded label-secondary"><?php echo mysqli_num_rows($qcount_support_logs); ?></span></a></li>
								<?php
								}
								?>
							</ul>
                        </li>
						
						<?php
						$qcount_all_support_queries = mysqli_query($conn, "SELECT id FROM tblclients_support_queries");
						?>
						<li class="<?php if ( $_GET ['page'] == "support_queries" )echo "active"; ?> <?php if( !admin_role($_SESSION ['AUTH_ID'], 9) )echo "hide"; ?>">
                            <a class="has-arrow <?php if ( $_GET ['page'] == "support_queries" )echo "active"; ?>" href="#" aria-expanded="false"><i class="fa far fa-envelope"></i><span class="hide-menu"> Support Emails</span></a>
                            <ul aria-expanded="false" class="collapse">
								<li class="<?php if ( $_GET ['page'] == "support_call_logs" && $_GET ['list'] == "all" )echo "active"; ?>"><a href="index.php?page=support_queries&list=all">View All <span class="label label-rounded label-secondary"><?php echo mysqli_num_rows($qcount_all_support_queries); ?></span></a></li>
								<?php
								$qsupport_queries = mysqli_query($conn, "SELECT * FROM tblsettings_support_queries ORDER BY sort ASC");
								while( $qsupport_queriesrow = mysqli_fetch_assoc( $qsupport_queries ) )
								{
								$qcount_support_queries = mysqli_query($conn, "SELECT id FROM tblclients_support_queries WHERE department='".$qsupport_queriesrow['id']."'");
								?>
									<li class="<?php if ( $_GET ['page'] == "support_call_logs" && $_GET ['view'] == $qsupport_queriesrow['id'] )echo "active"; ?>"><a href="index.php?page=support_queries&view=<?php echo $qsupport_queriesrow['id']; ?>"><?php echo $qsupport_queriesrow['title']; ?> <span class="label label-rounded label-secondary"><?php echo mysqli_num_rows($qcount_support_queries); ?></span></a></li>
								<?php
								}
								?>
							</ul>
                        </li>
						
						
						
						<li class="<?php if ( $_GET ['page'] == "products" )echo "active"; ?> <?php if( !admin_role($_SESSION ['AUTH_ID'], 10) )echo "hide"; ?>"><a href="index.php?page=products"><i class="fa fa-inbox"></i> Products / Services</a></li> 
						
						<?php
						$p_all = "SELECT * FROM tblclients_products ";
						$qproducts_all = mysqli_query ( $conn, $p_all );
						
						$p_active = "SELECT * FROM tblclients_products WHERE status='Active' ";
						$qproducts_active = mysqli_query ( $conn, $p_active );
						
						$p_pending = "SELECT * FROM tblclients_products WHERE status='Pending' ";
						$qproducts_pending = mysqli_query ( $conn, $p_pending );
						
						$p_suspended = "SELECT * FROM tblclients_products WHERE status='Suspended' ";
						$qproducts_suspended = mysqli_query ( $conn, $p_suspended );
						
						$p_cancelled = "SELECT * FROM tblclients_products WHERE status='Cancelled' ";
						$qproducts_cancelled = mysqli_query ( $conn, $p_cancelled );
						?>
						<li class="<?php if ( $_GET ['page'] == "orders" )echo "active"; ?> <?php if( !admin_role($_SESSION ['AUTH_ID'], 11) )echo "hide"; ?>">
                            <a class="has-arrow <?php if ( $_GET ['page'] == "orders" )echo "active"; ?>" href="#" aria-expanded="false"><i class="fa fa-bars"></i><span class="hide-menu"> Orders</span></a>
                            <ul aria-expanded="false" class="collapse">
								<li class="<?php if ( $_GET ['page'] == "orders" && $_GET ['status'] == "all" )echo "active"; ?>"><a href="index.php?page=orders&status=all">View All <span class="label label-rounded label-success"><?php echo mysqli_num_rows($qproducts_all); ?></span></a></li>
								<li class="<?php if ( $_GET ['page'] == "orders" && $_GET ['status'] == "active" )echo "active"; ?>"><a href="index.php?page=orders&status=active">Active <span class="label label-rounded label-success"><?php echo mysqli_num_rows($qproducts_active); ?></span></a></li>
								<li class="<?php if ( $_GET ['page'] == "orders" && $_GET ['status'] == "pending" )echo "active"; ?>"><a href="index.php?page=orders&status=pending">Pending <span class="label label-rounded label-warning"><?php echo mysqli_num_rows($qproducts_pending); ?></span></a></li>
								<li class="<?php if ( $_GET ['page'] == "orders" && $_GET ['status'] == "suspended" )echo "active"; ?>"><a href="index.php?page=orders&status=suspended">Suspended <span class="label label-rounded label-danger"><?php echo mysqli_num_rows($qproducts_suspended); ?></span></a></li>
								<li class="<?php if ( $_GET ['page'] == "orders" && $_GET ['status'] == "cancelled" )echo "active"; ?>"><a href="index.php?page=orders&status=cancelled">Cancelled <span class="label label-rounded label-secondary"><?php echo mysqli_num_rows($qproducts_cancelled); ?></span></a></li>
							</ul>
                        </li>
						
						<?php
						$i_all = "SELECT * FROM tblinvoices ";
						$qinvoice_all = mysqli_query ( $conn, $i_all );
						
						$i_paid = "SELECT * FROM tblinvoices WHERE status='Paid' ";
						$qinvoice_paid = mysqli_query ( $conn, $i_paid );
						
						$i_cancelled = "SELECT * FROM tblinvoices WHERE status='Cancelled' ";
						$qinvoice_cancelled = mysqli_query ( $conn, $i_cancelled );
						
						$i_unpaid = "SELECT * FROM tblinvoices WHERE status='Unpaid' ";
						$qinvoice_unpaid = mysqli_query ( $conn, $i_unpaid );
						?>
						<li class="<?php if ( $_GET ['page'] == "invoices" )echo "active"; ?> <?php if( !admin_role($_SESSION ['AUTH_ID'], 13) )echo "hide"; ?>">
                            <a class="has-arrow <?php if ( $_GET ['page'] == "invoices" )echo "active"; ?>" href="#" aria-expanded="false"><i class="fa fa-bookmark"></i><span class="hide-menu"> Invoices</span></a>
                            <ul aria-expanded="false" class="collapse">
								<li class="<?php if ( $_GET ['page'] == "invoices" && $_GET ['status'] == "" )echo "active"; ?>"><a href="index.php?page=invoices&status=">View All <span class="label label-rounded label-success"><?php echo mysqli_num_rows($qinvoice_all); ?></span></a></li>
								<li class="<?php if ( $_GET ['page'] == "invoices" && $_GET ['status'] == "paid" )echo "active"; ?>"><a href="index.php?page=invoices&status=paid">Paid <span class="label label-rounded label-success"><?php echo mysqli_num_rows($qinvoice_paid); ?></span></a></li>
								<li class="<?php if ( $_GET ['page'] == "invoices" && $_GET ['status'] == "unpaid" )echo "active"; ?>"><a href="index.php?page=invoices&status=unpaid">Unpaid <span class="label label-rounded label-danger"><?php echo mysqli_num_rows($qinvoice_unpaid); ?></span></a></li>
								<li class="<?php if ( $_GET ['page'] == "invoices" && $_GET ['status'] == "cancelled" )echo "active"; ?>"><a href="index.php?page=invoices&status=cancelled">Cancelled <span class="label label-rounded label-secondary"><?php echo mysqli_num_rows($qinvoice_cancelled); ?></span></a></li>
							</ul>
                        </li>

						<li class="<?php if ( $_GET ['page'] == "log_activity" || $_GET ['page'] == "log_email" )echo "active"; ?> <?php if( !admin_role($_SESSION ['AUTH_ID'], 17) )echo "hide"; ?>">
                            <a class="has-arrow <?php if ( $_GET ['page'] == "log_activity" || $_GET ['page'] == "log_email" )echo "active"; ?>" href="#" aria-expanded="false"><i class="fa fa-history"></i><span class="hide-menu"> Logs</span></a>
                            <ul aria-expanded="false" class="collapse">
								<li class="<?php if ( $_GET ['page'] == "log_activity")echo "active"; ?>"><a href="index.php?page=log_activity">Activity Log</a></li>
                                <li class="<?php if ( $_GET ['page'] == "log_email" )echo "active"; ?>"><a href="index.php?page=log_email">Email Log</a></li>
                            </ul>
                        </li>
						
						<?php
						$first_day = date("Y-m-01");
						$last_day = date("Y-m-t", strtotime(date("Y-m-d")));
						?>
						<li class="<?php if ( $_GET ['page'] == "reports_annually" || $_GET ['page'] == "reports_monthly" || $_GET ['page'] == "commission" )echo "active"; ?> <?php if( !admin_role($_SESSION ['AUTH_ID'], 18) )echo "hide"; ?>">
                            <a class="has-arrow" href="#" aria-expanded="false"><i class="fas fa-chart-bar"></i><span class="hide-menu"> Reports</span></a>
                            <ul aria-expanded="false" class="collapse">
								<li class="<?php if ( $_GET ['page'] == "reports_monthly" )echo "active"; ?>"><a href="index.php?page=reports_monthly&date_from=<?php echo $first_day; ?>&date_to=<?php echo $last_day; ?>">Monthly Statements</a></li>
								<li class="<?php if ( $_GET ['page'] == "reports_annually")echo "active"; ?>"><a href="index.php?page=reports_annually&year=<?php echo date("Y"); ?>">Annual Income Report</a></li>
								<li class="<?php if ( $_GET ['page'] == "commission")echo "active"; ?> <?php if( !admin_role($_SESSION ['AUTH_ID'], 39) )echo "hide"; ?>"><a href="index.php?page=commission&date_from=<?php echo $first_day; ?>&date_to=<?php echo $last_day; ?>">Commission Report</a></li>
						   </ul>
                        </li>
						
                        <li class="<?php if ( $_GET ['page'] == "settings" || $_GET ['page'] == "settings_administrators" || $_GET ['page'] == "settings_email" 
											  || $_GET ['page'] == "settings_notifications" || $_GET ['page'] == "settings_payments" || $_GET ['page'] == "settings_title"  
											  || $_GET ['page'] == "settings_gender" || $_GET ['page'] == "settings_sales_call_logs" || $_GET ['page'] == "settings_support_call_logs" || $_GET ['page'] == "settings_support_querries" || $_GET ['page'] == "settings_sales_pitches" 
											  || $_GET ['page'] == "settings_commission_structure" || $_GET ['page'] == "settings_benefits" || $_GET ['page'] == "settings_import" || $_GET ['page'] == "settings_roles"   
											  || $_GET ['page'] == "settings_documents" )echo "active"; ?> <?php if( !admin_role($_SESSION ['AUTH_ID'], 19) )echo "hide"; ?>">
                            <a class="has-arrow" href="#" aria-expanded="false"><i class="fa fa-cog"></i><span class="hide-menu"> Settings</span></a>
                            <ul aria-expanded="false" class="collapse">
								<li class="<?php if ( $_GET ['page'] == "settings")echo "active"; ?>"><a href="index.php?page=settings">General Settings</a></li>
                                <li class="<?php if ( $_GET ['page'] == "settings_administrators" )echo "active"; ?>"><a href="index.php?page=settings_administrators">Administrators</a></li>
								<li class="<?php if ( $_GET ['page'] == "settings_roles" )echo "active"; ?>"><a href="index.php?page=settings_roles">Administrator Roles</a></li>
                                <li class="<?php if ( $_GET ['page'] == "settings_title" || $_GET ['page'] == "settings_gender" || $_GET ['page'] == "settings_sales_call_logs" || $_GET ['page'] == "settings_support_call_logs" || $_GET ['page'] == "settings_support_querries" 
									|| $_GET ['page'] == "settings_sales_pitches" || $_GET ['page'] == "settings_commission_structure" || $_GET ['page'] == "settings_benefits" || $_GET ['page'] == "settings_documents" )echo "active"; ?>">
                                    <a class="has-arrow" href="#" aria-expanded="false">Application</a>
                                    <ul aria-expanded="false" class="collapse">
                                        <li class="<?php if ( $_GET ['page'] == "settings_title" )echo "active"; ?>"><a href="index.php?page=settings_title">Title</a></li>
                                        <li class="<?php if ( $_GET ['page'] == "settings_gender" )echo "active"; ?>"><a href="index.php?page=settings_gender">Gender</a></li>
										<li class="<?php if ( $_GET ['page'] == "settings_sales_call_logs" )echo "active"; ?>"><a href="index.php?page=settings_sales_call_logs">Sales Call Logs</a></li>
										<li class="<?php if ( $_GET ['page'] == "settings_support_call_logs" )echo "active"; ?>"><a href="index.php?page=settings_support_call_logs">Support Call Logs</a></li>
										<li class="<?php if ( $_GET ['page'] == "settings_support_querries" )echo "active"; ?>"><a href="index.php?page=settings_support_querries">Support Querries</a></li>
										<li class="<?php if ( $_GET ['page'] == "settings_sales_pitches" )echo "active"; ?>"><a href="index.php?page=settings_sales_pitches">Sales Pitches</a></li>
										<li class="<?php if ( $_GET ['page'] == "settings_commission_structure" )echo "active"; ?>"><a href="index.php?page=settings_commission_structure">Commission Structure</a></li>
										<li class="<?php if ( $_GET ['page'] == "settings_benefits" )echo "active"; ?>"><a href="index.php?page=settings_benefits">Benefits Included</a></li>
										<li class="<?php if ( $_GET ['page'] == "settings_documents" )echo "active"; ?>"><a href="index.php?page=settings_documents">File Categories</a></li>
                                    </ul>
                                </li>
								<li class="<?php if ( $_GET ['page'] == "settings_email" ||  $_GET ['page'] == "settings_notifications" )echo "active"; ?>">
                                    <a class="has-arrow" href="#" aria-expanded="false">Emails</a>
                                    <ul aria-expanded="false" class="collapse">
                                        <li class="<?php if ( $_GET ['page'] == "settings_email" )echo "active"; ?>"><a href="index.php?page=settings_email">Email Settings</a></li>
                                        <li class="<?php if ( $_GET ['page'] == "settings_notifications" )echo "active"; ?>"><a href="index.php?page=settings_notifications">Email Notifications</a></li>
                                    </ul>
                                </li>
								<li class="<?php if ( $_GET ['page'] == "settings_payments" )echo "active"; ?>"><a href="index.php?page=settings_payments">Payments</a></li>
								<li class="<?php if ( $_GET ['page'] == "settings_import" )echo "active"; ?>"><a href="index.php?page=settings_import">Import</a></li>
                            </ul>
                        </li>
						
						
                    </ul>
                </nav>
            </div>
        </aside>
        <div class="page-wrapper">
            <div class="container-fluid">
                <div class="row page-titles">
                    <div class="col-md-12 col-8 align-self-center">
						<?php 
						if ( isset( $_GET['save'] ) )fetch_note ( "save" );
						if ( isset( $_GET['import'] ) )fetch_note ( "import" );
						if ( isset( $_GET['send'] ) )fetch_note ( "send" );
						if ( isset( $_GET['upload'] ) )fetch_note ( "upload" );
						if ( isset( $_GET['exceedtotal'] ) )fetch_note ( "exceedtotal" );
						if ( isset( $_GET['creditexceedtotal'] ) )fetch_note ( "creditexceedtotal" );
						if ( isset( $_GET['exceedbalance'] ) )fetch_note ( "exceedbalance" );
						?>
                    </div>
                </div>
                <?php
				page_main($conn);
				?> 
            </div>
            <footer class="footer">
				<div class="text-md-right">
                	Copyright &copy; <?php echo date("Y"); ?> <?php echo $qsettingsrow['title']; ?>
				</div>
            </footer>
        </div>
    </div>
   
    <!-- All Jquery -->
    <script src="../vendors/jquery/jquery.min.js"></script>
    <!-- Bootstrap tether Core JavaScript -->
    <script src="../vendors/bootstrap/js/popper.min.js"></script>
    <script src="../vendors/bootstrap/js/bootstrap.min.js"></script>
    <!-- slimscrollbar scrollbar JavaScript -->
    <script src="../js/jquery.slimscroll-admin.js"></script>
    <!--Wave Effects -->
    <script src="../js/waves.js"></script>
    <!--Menu sidebar -->
    <script src="../js/sidebarmenu.js"></script>
    <!--stickey kit -->
    <script src="../vendors/sticky-kit-master/dist/sticky-kit.js"></script>
	<!-- This is data table -->
    <script src="../vendors/datatables/datatables.min.js"></script>
	<!-- start - This is for export functionality only -->
    <script src="https://cdn.datatables.net/buttons/1.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.2.2/js/buttons.flash.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/2.5.0/jszip.min.js"></script>
    <script src="https://cdn.rawgit.com/bpampuch/pdfmake/0.1.18/build/pdfmake.min.js"></script>
    <script src="https://cdn.rawgit.com/bpampuch/pdfmake/0.1.18/build/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.2.2/js/buttons.print.min.js"></script>
    <!-- end - This is for export functionality only -->
	<!-- Sweet-Alert  -->
    <script src="../vendors/sweetalert/sweetalert.min.js"></script>
    <script src="../vendors/sweetalert/jquery.sweet-alert.custom.js"></script>
	<script src="../js/alerts.js"></script>
	<!-- Date Picker Plugin -->
	<script src="../vendors/moment/moment.js"></script>
	<script src="../vendors/bootstrap-datepicker/bootstrap-datepicker.min.js"></script>
	<!-- Date range Plugin JavaScript -->
	<script src="../vendors/timepicker/bootstrap-timepicker.min.js"></script>
	<script src="../vendors/daterangepicker/daterangepicker.js"></script>
	<script src="../vendors/daterangepicker/dates.js"></script>
	
    <!--Custom JavaScript -->
    <script src="../js/custom-admin.min.js"></script>
	<script src="../js/extras.js"></script>
	<script src="../js/bulk-actions.js"></script>
	
	<script>
   
        $(document).ready(function() {
		
			$('#myTable').DataTable( {
				dom: "Bfrtip",
				  buttons: [
					{
					  extend: "copyHtml5",
					},
					{
					  extend: "excelHtml5",
					  exportOptions: {
						columns: "thead th:not(.noExport)"
					  }
					},
					
					{
					  extend: "pdfHtml5",
					},
					{
					  extend: "print",
					  customize: function ( win ) {
							$(win.document.body)
								.css( 'font-size', '10pt' )
								.css( 'background', '#ffffff' )
		 
							$(win.document.body).find( 'table' )
								.addClass( 'compact' )
								.removeClass( 'table-striped' )
								.removeClass( 'jambo_table' )
								.css( 'font-size', 'inherit' );
						}
					},
					{
					  extend: "pageLength",
					},
				  ],
				<?php
				if($_GET['page'] == "reports_stationery")
				{
					?>
					"ordering": false,
					<?php
				}
				else
				{
					?>
					"ordering": true,
					<?php
				}
				?>
				<?php
				if($_GET['page'] == "commission" || $_GET['page'] == "settings_commission_structure" || $_GET['page'] == "settings_role_groups" || $_GET['page'] == "settings_grades" || $_GET['page'] == "products" || $_GET['page'] == "stationery")
				{
					?>
					'order': [[ 0, 'asc' ]],
					<?php
				}
				else if($_GET['page'] == "support_queries" || $_GET['page'] == "support_call_logs" || $_GET['page'] == "log_email" || $_GET['page'] == "log_activity" || $_GET['page'] == "invoices" || $_GET['page'] == "orders" || ($_GET['page'] == "parents" && isset($_GET['func'])) || ($_GET['page'] == "registrants" && $_GET['func'] == "emails") || ($_GET['page'] == "reps" && $_GET['func'] == "emails") || ($_GET['page'] == "registrants" && $_GET['func'] == "credits" ) 
				|| ($_GET['page'] == "registrants" && $_GET['func'] == "orders") || ($_GET['page'] == "registrants" && $_GET['func'] == "sales_call_logs") || ($_GET['page'] == "registrants" && $_GET['func'] == "support_call_logs") || ($_GET['page'] == "registrants" && $_GET['func'] == "invoices") || ($_GET['page'] == "registrants" && $_GET['func'] == "support_queries") )
				{
					?>
					'order': [[ 0, 'desc' ]],
					<?php
				}
				else if($_GET['page'] == "parents" && !isset($_GET['func']) || $_GET['page'] == "registrants")
				{
					?>
					'order': [[ 2, 'asc' ]],
					<?php
				}
				else if($_GET['page'] == "settings_import")
				{
					?>
					'order': [[ 1, 'desc' ]],
					<?php
				}
				else
				{
					?>
					'order': [[ 1, 'asc' ]],
					<?php
				}
				?>
				"iDisplayLength": 100,
				"lengthMenu": [[25, 50, 100, 200, 500], [25, 50, 100, 200, 500]]
			} );
			
		} );
    	$('.buttons-copy, .buttons-csv, .buttons-print, .buttons-pdf, .buttons-excel').addClass('btn btn-secondary mr-1');
	</script>
	
	<!-- Autocomplete Search -->
    <script src="../config/typeahead.js"></script>    
	<script>
	$(document).ready(function () {
        $('#autocomplete').typeahead({
            source: function (query, result) {
                $.ajax({
                    url: "../includes/autocomplete.php",
                    dataType: "json",
                    success: function (data) {
						result($.map(data, function (item) {
							return item;
                        }));
                    }
                });
            }
        });
    });
	
	</script>
	
	
    <?php if ( function_exists('page_config_footer') ){page_config_footer($conn);} ?>
</body>

</html>
